/*
 * Copyright (c) Doug Palmer <doug@charvolant.org> 2005
 *
 * See LICENSE for licensing details.
 * 
 * $Id$
 */

package org.charvolant.sudoku.gui;

import java.awt.*;
import java.awt.event.*;

import org.charvolant.sudoku.*;

/**
 * A general game panel containing a board and
 * a bunch of buttons to do something interesting.
 * 
 * @author doug
 *
 */
public class GamePanel extends Panel {
  /** The game board */
  private Board board;
  /** The board */
  private BoardPanel boardPanel;
  /** The undo button */
  private Button undo;
  /** The step button */
  private Button step;
  
  /**
   * Construct around a game board.
   * 
   * @param board The game board
   */
  public GamePanel(Board board) {
    super(new GridBagLayout());
    this.board = board;
    this.initialise();
  }

  protected void initialise() {
    this.boardPanel = new BoardPanel(this.board);
    this.add(this.boardPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, GridBagConstraints.NORTH, GridBagConstraints.BOTH, new Insets(5, 5, 5, 5), 0, 0));
    this.undo = new Button("Undo");
    this.add(this.undo, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    this.undo.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        GamePanel.this.board.getContext().backtrack();
      }
    });
    this.step = new Button("Step");
    this.add(this.step, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(5, 5, 5, 5), 0, 0));
    this.step.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        GamePanel.this.board.getContext().choiceUser();
        GamePanel.this.board.step();
      }
    });
  }
  
  /**
   * Open a frame onto this panel.
   */
  public void openFrame() {
    Frame frame = new Frame("SuDoKu");
    
    frame.add(this);
    frame.addWindowListener(new WindowAdapter() {
      @Override
      public void windowClosing(WindowEvent e) {
        super.windowClosing(e);
        System.exit(0);
      }
    });
    frame.pack();
    frame.setVisible(true);
  }
}
